/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.flashlauncher.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    private FileUtils() {
    }

    public static void unzip(File file, File file2) throws IOException {
        FileUtils.unzip(file, file2, new FileFilter(){

            public boolean accept(File file) {
                return true;
            }
        });
    }

    private static void unzip(File file, File file2, FileFilter fileFilter) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!fileFilter.accept(new File(file2, string))) continue;
            if (zipEntry.isDirectory()) {
                new File(file2, string).mkdirs();
                continue;
            }
            File file3 = new File(file2, string);
            file3.getParentFile().mkdirs();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            FileUtils.copyAndClose(inputStream, fileOutputStream, false);
        }
        zipFile.close();
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        int n;
        bl = false;
        if (bl) {
            inputStream = new BufferedInputStream(inputStream);
            outputStream = new BufferedOutputStream(outputStream);
        }
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static void copyAndClose(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        FileUtils.copy(inputStream, outputStream, bl);
        inputStream.close();
        outputStream.close();
    }
}

